<?php


include "../../conn.php"; // Keep database connection

header('Content-Type: application/json; charset=utf-8');

// Default response
$response = [
    'success' => false,
    'message' => 'Invalid request',
    'data' => []
];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Get POST data
    $input = json_decode(file_get_contents("php://input"), true);
    
    if (isset($input['userId'])) {
        $userId = mysqli_real_escape_string($conn, $input['userId']);
        
        // Get user's referral code
        $codeQuery = "SELECT owncode FROM shonu_subjects WHERE id = '$userId'";
        $codeResult = $conn->query($codeQuery);
        
        if ($codeResult && $codeRow = mysqli_fetch_assoc($codeResult)) {
            $referralCode = $codeRow['owncode'];
            
            // Get all referred users with their levels
            $referredQuery = "SELECT 
                                id, 
                                codechorkamukala as nickname,
                                CASE
                                    WHEN code = '$referralCode' THEN 1
                                    WHEN code1 = '$referralCode' THEN 2
                                    WHEN code2 = '$referralCode' THEN 3
                                    WHEN code3 = '$referralCode' THEN 4
                                    WHEN code4 = '$referralCode' THEN 5
                                    WHEN code5 = '$referralCode' THEN 6
                                END as lv
                            FROM shonu_subjects 
                            WHERE code = '$referralCode' 
                            OR code1 = '$referralCode'
                            OR code2 = '$referralCode'
                            OR code3 = '$referralCode'
                            OR code4 = '$referralCode'
                            OR code5 = '$referralCode'
                            ORDER BY lv ASC, id ASC";
                            
            $referredResult = $conn->query($referredQuery);
            
            $referredUsers = [];
            $levelCounts = [
                1 => 0, 2 => 0, 3 => 0, 
                4 => 0, 5 => 0, 6 => 0
            ];
            
           while ($row = mysqli_fetch_assoc($referredResult)) {
                $userId = $row['id'];
                
                // Get date-wise recharge data
                $rechargeQuery = "SELECT 
                    DATE(dinankavannuracisi) as date,
                    COALESCE(SUM(motta), 0) as daily_recharge,
                    COUNT(*) as daily_count 
                    FROM thevani 
                    WHERE sthiti = '1' 
                    AND balakedara = '$userId'
                    GROUP BY DATE(dinankavannuracisi)
                    ORDER BY date DESC";
                $rechargeResult = $conn->query($rechargeQuery);
                $rechargeHistory = [];
                while($recharge = mysqli_fetch_assoc($rechargeResult)) {
                    $rechargeHistory[] = [
                        'date' => $recharge['date'],
                        'amount' => (float)$recharge['daily_recharge'],
                        'count' => (int)$recharge['daily_count']
                    ];
                }

                // Get date-wise withdrawal data
                $withdrawalQuery = "SELECT 
                    DATE(dinankavannuracisi) as date,
                    COALESCE(SUM(motta), 0) as daily_withdrawal,
                    COUNT(*) as daily_count 
                    FROM hintegedukolli 
                    WHERE sthiti = '1' 
                    AND balakedara = '$userId'
                    GROUP BY DATE(dinankavannuracisi)
                    ORDER BY date DESC";
                $withdrawalResult = $conn->query($withdrawalQuery);
                $withdrawalHistory = [];
                while($withdrawal = mysqli_fetch_assoc($withdrawalResult)) {
                    $withdrawalHistory[] = [
                        'date' => $withdrawal['date'],
                        'amount' => (float)$withdrawal['daily_withdrawal'],
                        'count' => (int)$withdrawal['daily_count']
                    ];
                }

                // Calculate totals
                $totalRecharge = array_sum(array_column($rechargeHistory, 'amount'));
                $totalRechargeCount = array_sum(array_column($rechargeHistory, 'count'));
                $totalWithdrawal = array_sum(array_column($withdrawalHistory, 'amount'));
                $totalWithdrawalCount = array_sum(array_column($withdrawalHistory, 'count'));

                $referredUsers[] = [
                    'userId' => (int)$row['id'],
                    'nickname' => $row['nickname'],
                    'lv' => (int)$row['lv'],
                    'recharge' => [
                        'total' => $totalRecharge,
                        'count' => $totalRechargeCount,
                        'history' => $rechargeHistory
                    ],
                    'withdrawal' => [
                        'total' => $totalWithdrawal,
                        'count' => $totalWithdrawalCount,
                        'history' => $withdrawalHistory
                    ]
                ];
                
                // Count users per level
                $levelCounts[$row['lv']]++;
            }
            
            $response = [
                'success' => true,
                'message' => 'Referred users retrieved successfully',
                'data' => [
                    'totalCount' => count($referredUsers),
                    'levelCounts' => $levelCounts,
                    'referredUsers' => $referredUsers
                ]
            ];
        } else {
            $response['message'] = 'User not found';
        }
    } else {
        $response['message'] = 'Missing userId parameter';
    }
}

echo json_encode($response);